% ------------------------------------------------------------------------
% Script: infile_2d
% ------------------------------------------------------------------------
% Aim: 
% one example of infile.m file for 2D P-N model
% ------------------------------------------------------------------------

    % System name
 
    system='2d P-N model';
 
    % The absolute path to save the result files
 
    filepath=pwd;
 
    % The dimension of P-N model: 1 or 2 

    misdim=2;
 
%% -----------------------------------------------------------------------
% The Parameters for the calculation of dislocation core structure
% ------------------------------------------------------------------------ 
    
    % % Calculating the dislocation core structure ('TRUE') or NOT ('FALSE')
    
    Dislocation_Core_Structure='TRUE';
 
    % % the data of GSFE (unit: J/m2) and normalized disregistry vector (unit: 1)
    
    [Ux,Uz]=meshgrid(0:0.1:1,0:0.0666:1);
    SFE=[0	89.08621	281.95114	425.81869	527.63899	561.82335	528.30477	471.2359	425.78951	367.03728	309.34262	371.75231	387.66181	247.24043	81.51731	0.02378;
64.81665	137.64965	306.06075	429.13461	511.82297	535.51971	499.50175	447.67643	416.91445	397.87276	356.71231	397.73711	399.695	289.73945	144.29717	65.12792;
219.68737	250.31911	362.29091	430.35052	474.18867	473.50073	419.93531	370.33375	360.98367	392.0191	412.07458	427.97058	429.34591	368.74388	278.74601	219.97162;
364.09045	370.62448	410.24964	416.73882	432.68939	406.77754	323.95354	239.53642	220.49635	302.26603	403.74641	459.52642	483.94297	452.1272	391.55921	364.21583;
430.40348	413.0873	370.32294	367.42097	411.78331	358.64048	217.15827	88.0816	81.25791	221.57068	376.29873	483.45444	536.96961	523.76483	471.94437	428.93899;
448.37841	409.86757	327.02952	327.00466	409.56278	325.30401	163.849	22.56459	22.64889	187.55492	363.72676	491.56267	557.07158	548.93633	496.60302	444.95009;
428.12297	413.50071	371.16543	368.0808	411.66388	360.34599	219.04483	89.01001	81.75508	223.18378	377.93021	481.73596	532.7096	518.27054	467.45793	426.94057;
359.35759	367.42313	409.65465	417.78071	435.17579	409.82542	328.51077	244.24821	224.01493	304.60868	405.11904	457.02759	479.13607	445.53264	385.82498	360.31249;
215.55003	247.53008	360.40814	431.37621	477.92611	480.13096	426.70063	374.30086	364.56115	393.76244	412.10215	426.80061	427.19294	364.91349	273.30792	215.75593;
63.82122	136.20299	304.08665	429.54532	515.58959	541.49496	505.18897	451.05125	417.75856	396.82978	356.33727	396.47365	399.66798	287.44057	142.35604	64.46214;
-0.44097	88.82519	282.88875	426.16617	528.25181	562.00817	528.44527	471.59851	425.78951	367.03728	309.34262	371.75231	387.66181	247.24043	81.51731	0.33289]'/1E3;

    % % Which trial function of disregistry vector to employ (>=-1)
    
    Nmis=0;     
     
    % % The value of Burgers vector (unit: A)
 
    BurVect=2.923;
 
    % % The values of shear modulus (unit: GPa) and Poisson's ratio (unit: 1)
 
    shear_modulus=43.33;
    poisson_ratio=0.335;
 
    % % The dislocation type: edge ('e') or screw ('s')

    mistype='e';
    
    % % Which GSFE fitting function to employ (>=-1)
    
    fitcut=0;
    
    % % Mode of P-N models: CCPN (1) or SVPN (2)

    pnmode=2;
    
    % % Interplanar distance ?x (unit: A)
    
    Inpas=1/2*BurVect;
    
    % % The reference position x_m is defined as x_m=m?x+dax for SVPN model
    %   (m=0, 1, 2, , ?)
 
    dax=0.0;
 
   % % Matrix of the lower and upper bounds, and initial values of each unknown 
   %   variable ([Lower bound, Upper bound, StartPoint]) 
  
    Xcoef_range=[0.00, 1.00, 0.200];
    Xdist_range=[-50.00, 50.00, 8.00];
    Xwid_range=[0.00,20.00, 1.00];
    dx_range=[-5.00,5.00, 0.00];
    
    % % The minimization method for 2D P-N model: PSO ('2d_PSO') or GA ('2d_GA')
 
    minimethod='2d_PSO';   
    
    % % PSO or GA Parameters
 
        % % % Size of the population and maximum number of iteration
 
        PopulationSize=100;
        MaxIterations=1000;
       
%% -----------------------------------------------------------------------
% The Parameters for the calculation of Peierls stress
% ------------------------------------------------------------------------
 
    % % Calculating the Peierls stress ('TRUE') or NOT ('FALSE')
    
    Peierls_Stress='TRUE';
 
    % % The method to calculate the Peierls stress: 1 or 2
    
    pnstrmethod=2;
    
    % % Interplanar distance ?x (unit: A) 

    % Inpas=BurVect;
    
%% -----------------------------------------------------------------------
% The Parameters for the calculation of pressure field around dislocation core
% ------------------------------------------------------------------------
 
    % % Calculating the pressure field around dislocation core ('TRUE') or NOT ('FALSE')
    
    Pressure_Field='FALSE';
    
    % % The lattice matrix for pressure field
    
    % pressfld_latxz=[];
    % pressfld_latyy=[];
    
        % % % >>> For edge dislocation of FCC and HCP structures
 
        % LatC_spacing=sqrt(2/3)/2*BurVect;
        % [pressfld_latxz,pressfld_latyy]=meshgrid(-(7+1/4)*BurVect:(1/2*BurVect):(7+1/4)*BurVect,...
        %                                -(14+1/2)*LatC_spacing:LatC_spacing:(14+1/2)*LatC_spacing);
 
        % % % >>> For screw dislocation of FCC structure
 
        % pressfld_latxz=sqrt(3)*repmat([-(7+1/4)*BurVect:(1/2*BurVect):(7+1/4)*BurVect;...
        %                                -(7+7/12)*BurVect:(1/2*BurVect):(6+11/12)*BurVect;...
        %                                -(7+5/12)*BurVect:(1/2*BurVect):(7+1/12)*BurVect],10,1);
        % pressfld_latyy=repmat([-(14+1/2)*LatC_spacing:LatC_spacing:(14+1/2)*LatC_spacing]',1,30);
 
        % % % >>> For screw dislocation of HCP structure
 
        % pressfld_latxz=sqrt(3)*repmat([-(7+1/4)*BurVect:(1/2*BurVect):(7+1/4)*BurVect;...
        %                                -(7+5/12)*BurVect:(1/2*BurVect):(7+1/12)*BurVect],15,1);
        % pressfld_latyy=repmat([-(14+1/2)*LatC_spacing:LatC_spacing:(14+1/2)*LatC_spacing]',1,30);
 
    % % Which component of the dislocation to calculate: x or z
    
    % dis_component_xz='x';
 
%% -----------------------------------------------------------------------
% The Parameters for the calculation of solid solution strengthening
% ------------------------------------------------------------------------
 
    % % Calculating the solid solution strengthening ('TRUE') or NOT ('FALSE')
    
    Solution_Strengthening='FALSE';
    
    % % Plotting the position-dependent solute/dislocation interaction energy
    %   ('TRUE') or NOT ('FALSE')
    
    % Einteraction_Plot='TRUE';
    
    % % The input volumetric misfit (eb_input) and slip misfit (es_input) parameters
    
    % eb_input=[];
    % es_input=[];
 
    % % The interlayer spacing along FCC [111] or HCP [0001] direction
 
    % LatC_spacing=[];

        % % % >>> for FCC structure

        % LatC_spacing=sqrt(2/3)/2*BurVect; 
 
    % % The coefficient to calculate the extra volume (unit: A^3), i.e. dV=coefV*eb
    
    % coefV=[];

        % % % >>> for FCC structure
    
        % coefV=3/4*(sqrt(2)*BurVect)^3;

    % % Matrix of the lower and upper bounds to search the characteristic bow-out distance wc (unit: A)
    
    % wc_range=[];        
        
    % % Concentration of solute atom
 
    % solute_concentration=1;
